unit Unit1;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms,  Dialogs, ExtCtrls,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
  public
  end;

//     
type TUnitProc = procedure();
//    
type TObjProc = procedure() of object;
//    
type
  TAUTO = class(TThread)
  private
     //   
     WTimer    : TTimer;
     panAUTO   : TPanel;
     stxTime   : TStaticText;
     lbTime    : TLabel;
     //   
     procedure DoOnTimer(Sender: TObject);
     procedure DoStartFromSourcer(RqOn : boolean);
     procedure DoStopToSourcer();
     procedure StopToSourcer();
     procedure StartToReceiver();
     procedure DoStartToReceiver();
     procedure DoStopFromReceiver(RqOFF : boolean);

  protected
     FTimeOut      : word;
     FRunFlag      : boolean;  //  
     FSourcerFlag  : boolean;  //   
     FReceiverFlag : boolean;  //   
     FData         : word;
     FProcStopToSourcer   : TUnitProc;
     FProcStartToReceiver : TUnitProc;
     //   
     procedure Execute(); override;
  public
     property StartFromSourcer : boolean
              read FSourcerFlag  write DoStartFromSourcer;
     property StopFromReceiver : boolean
              read FReceiverFlag write DoStopFromReceiver;
     property Data : word read FData write FData;
    //  / 
    constructor CreateAUTO(CreateSuspended: Boolean; Owner : TWinControl);
    destructor  DestroyAUTO();
  end;

  //  
  function NewLabel
         ( Owner  : TWinControl; RqName : string; RqTop : integer;
           RqLeft : integer; RqCaption  : string ) : TLabel;
  function NewStaticText
         ( Owner : TWinControl; RqName : string;
           RqTop : integer; RqLeft : integer ) : TStaticText;
  function NewPanel
         ( Owner : TWinControl; RqName : string;
           RqTop : integer; RqLeft : integer ) : TPanel;

  //   
  var
  Form1 : TForm1;
  AUTO  : TAUTO;
implementation
{$R *.dfm}

// ==============================
//  / 
// ==============================
constructor TAUTO.CreateAUTO(CreateSuspended: Boolean; Owner : TWinControl);
begin
  //   AUTO
  Create(CreateSuspended);
  //    
  WTimer := TTimer.Create(Owner);
  WTimer.OnTimer := DoOnTimer;
  WTimer.Interval := 100;
  //      
  panAUTO := NewPanel(Owner, 'panAUTO', 90, 20);
  //     
  stxTime := NewStaticText(panAUTO, 'stxTime', 24, 10);
  lbTime  := NewLabel(panAUTO, 'lbTime', 24, 80, '');
end;

destructor TAUTO.DestroyAUTO();
begin
  stxTime.Free; lbTime.Free;
  panAUTO.Free; WTimer.Free;
  //  
  inherited Destroy;
end;
//   
procedure TAUTO.Execute;
begin
  repeat
    // ==================

    // ==================
    if FSourcerFlag then StopToSourcer();
    Suspend;
  until Terminated;
end;
//   Timer 
procedure TAUTO.DoOnTimer (Sender: TObject);
begin
  stxTime.Caption := TimeToStr(Now);
end;
// ----------------------------------------
//     
//    
procedure TAUTO.DoStartFromSourcer(RqOn : boolean);
begin
 if RqOn and (not FRunFlag)
 then begin
    FRunFlag := True;
    FSourcerFlag := True;
    Resume;  //  
 end;
end;
//    
procedure TAUTO.StopToSourcer();
begin
  DoStopToSourcer();
  //    
  Synchronize(DoStopToSourcer);
  FSourcerFlag := False;
  FRunFlag := False;
end;
//    
//     
procedure TAUTO.DoStopToSourcer();
begin
  if Assigned(FProcStopToSourcer)
  then FProcStopToSourcer();
end;
// ----------------------------------------
//     
//    
procedure TAUTO.StartToReceiver();
begin
  FRunFlag := True;
  FReceiverFlag := True;
  StartToReceiver();
  //    
  Synchronize(DoStartToReceiver);
  if FTimeOut = 0
  then begin
    FRunFlag := False;
    FReceiverFlag := False;
  end;
end;
//    
//     
procedure TAUTO.DoStartToReceiver();
begin
  if Assigned(FProcStartToReceiver)
  then FProcStartToReceiver();
end;

// ++++++++ +++++++ ++++++++++
//    
// ++++++++ +++++++ ++++++++++
procedure TAUTO.DoStopFromReceiver(RqOFF : boolean);
begin
  if RqOFF and FReceiverFlag then Resume;
end;
// =========== END OF TAUTO ===============


//   TLabel
  function NewLabel
    (Owner  : TWinControl; RqName : string;  RqTop : integer;
     RqLeft : integer;  RqCaption : string ) : TLabel;
var WCTRL   : TLabel;
begin
  WCTRL := TLabel.Create(Owner);
  WCTRL.Parent := Owner;
  with WCTRL do begin
       Name := RqName; Top := RqTop; Left := RqLeft;
       Caption := RqCaption; Visible := True;
  end; Result := WCTRL;
end;
//   TStaticText
function NewStaticText
       ( Owner : TWinControl; RqName : string;
         RqTop : integer; RqLeft : integer ) : TStaticText;
var WCTRL : TStaticText;
begin
  WCTRL := TStaticText.Create(Owner);
  WCTRL.Parent := Owner;
  with WCTRL do begin
       Name := RqName; Top := RqTop; Left := RqLeft;
       Height := 16; Width := 60; BorderStyle := sbsSunken;
       AutoSize := False; Alignment := taCenter;
       Caption := ''; Visible := True;
  end; Result := WCTRL;
end;
//   TPanel
function NewPanel
      ( Owner : TWinControl; RqName : string;
        RqTop : integer; RqLeft : integer ) : TPanel;
var WCTRL : TPanel;
begin
  WCTRL := TPanel.Create(Owner);
  WCTRL.Parent := Owner;
  with WCTRL do begin
       Name := RqName; Top := RqTop; Left := RqLeft;
       Height := 100; Width := 150;
       Caption :=''; Visible := True;
  end; Result := WCTRL;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  AUTO := TAUTO.CreateAUTO(True, Form1);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  AUTO.DestroyAUTO;
end;

end.
